/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.AnnotationDefault;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethods;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.EnclosingMethod;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.MethodParameters;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.PMGClass;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.UnknownAttributeReader;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Attribute
implements Cloneable,
Node {
    private int name_index;
    private int length;
    private final byte tag;
    private ConstantPool constant_pool;
    private static final Map<String, Object> readers = new HashMap<String, Object>();

    protected Attribute(byte by, int n, int n2, ConstantPool constantPool) {
        this.tag = by;
        this.name_index = n;
        this.length = n2;
        this.constant_pool = constantPool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    public static void addAttributeReader(String string, UnknownAttributeReader unknownAttributeReader) {
        readers.put(string, unknownAttributeReader);
    }

    public static void removeAttributeReader(String string) {
        readers.remove(string);
    }

    public static Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        return Attribute.readAttribute((DataInput)dataInputStream, constantPool);
    }

    public static Attribute readAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFormatException {
        int n = -1;
        int n2 = dataInput.readUnsignedShort();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(n2, (byte)1);
        String string = constantUtf8.getBytes();
        int n3 = dataInput.readInt();
        for (int n4 = 0; n4 < 22; n4 = (int)((byte)(n4 + 1))) {
            if (!string.equals(Const.getAttributeName(n4))) continue;
            n = n4;
            break;
        }
        switch (n) {
            case -1: {
                Object object = readers.get(string);
                if (object instanceof UnknownAttributeReader) {
                    return ((UnknownAttributeReader)object).createAttribute(n2, n3, dataInput, constantPool);
                }
                return new Unknown(n2, n3, dataInput, constantPool);
            }
            case 1: {
                return new ConstantValue(n2, n3, dataInput, constantPool);
            }
            case 0: {
                return new SourceFile(n2, n3, dataInput, constantPool);
            }
            case 2: {
                return new Code(n2, n3, dataInput, constantPool);
            }
            case 3: {
                return new ExceptionTable(n2, n3, dataInput, constantPool);
            }
            case 4: {
                return new LineNumberTable(n2, n3, dataInput, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n2, n3, dataInput, constantPool);
            }
            case 6: {
                return new InnerClasses(n2, n3, dataInput, constantPool);
            }
            case 7: {
                return new Synthetic(n2, n3, dataInput, constantPool);
            }
            case 8: {
                return new Deprecated(n2, n3, dataInput, constantPool);
            }
            case 9: {
                return new PMGClass(n2, n3, dataInput, constantPool);
            }
            case 10: {
                return new Signature(n2, n3, dataInput, constantPool);
            }
            case 11: {
                return new StackMap(n2, n3, dataInput, constantPool);
            }
            case 12: {
                return new RuntimeVisibleAnnotations(n2, n3, dataInput, constantPool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(n2, n3, dataInput, constantPool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(n2, n3, dataInput, constantPool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(n2, n3, dataInput, constantPool);
            }
            case 16: {
                return new AnnotationDefault(n2, n3, dataInput, constantPool);
            }
            case 17: {
                return new LocalVariableTypeTable(n2, n3, dataInput, constantPool);
            }
            case 18: {
                return new EnclosingMethod(n2, n3, dataInput, constantPool);
            }
            case 19: {
                return new StackMap(n2, n3, dataInput, constantPool);
            }
            case 20: {
                return new BootstrapMethods(n2, n3, dataInput, constantPool);
            }
            case 21: {
                return new MethodParameters(n2, n3, dataInput, constantPool);
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + n);
    }

    public String getName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public Object clone() {
        Attribute attribute = null;
        try {
            attribute = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
        return attribute;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Const.getAttributeName(this.tag);
    }
}

